/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWException;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditorForFieldTable;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWExpression;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWEditorTool;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWArrayEditorTable;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWArrayEditorTableModel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionEditor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

class VWArrayEditor
extends JPanel
implements ActionListener,
IVWToolbarBorderActionListener,
IVWEditorTool,
ListSelectionListener {
    private VWToolbarBorder m_arrayEditorBorder = null;
    private VWArrayEditorTable m_arrayEditorTable = null;
    private VWArrayEditorTableModel m_arrayEditorTableModel = null;
    private JButton m_getArrayButton = null;
    private GridBagConstraints m_gbCons = null;
    private VWExpressionEditor m_expressionEditor = null;
    private boolean m_isFirstTime = true;
    private IVWPropertyData m_propertyData = null;
    private String m_name = null;
    private int m_type = -1;

    public VWArrayEditor(VWExpressionEditor expressionEditor, IVWPropertyData propertyData, String name, int type) {
        this.m_expressionEditor = expressionEditor;
        this.m_propertyData = propertyData;
        this.m_name = name;
        this.m_type = type;
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initControls();
    }

    public void setCurrentExpressionItem(String expressionItem) {
        if (expressionItem != null) {
            String[] array = VWExpression.stringToArray(expressionItem);
            this.m_arrayEditorTableModel.init(array);
            this.m_arrayEditorTableModel.reinitialize();
        }
    }

    public void setEnabled(boolean enable) {
        this.m_arrayEditorTable.setEnabled(enable);
        this.m_arrayEditorBorder.setEnabled(enable);
        if (enable) {
            int rowCount = this.m_arrayEditorTableModel.getRowCount();
            if (rowCount > 0) {
                this.m_arrayEditorTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 1, 16));
            }
        } else {
            this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isFirstTime) {
            this.m_isFirstTime = false;
            if (this.m_arrayEditorTable != null) {
                this.m_arrayEditorTable.fitColumnsInTable();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_getArrayButton)) {
            this.performGetArrayButtonAction();
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        if (event.getSource().equals(this.m_arrayEditorBorder)) {
            this.m_arrayEditorTable.stopEditing();
            switch (event.getID()) {
                case 16: {
                    this.performAddAction(this.getDefaultValue());
                    break;
                }
                case 1: {
                    this.performUpAction();
                    break;
                }
                case 2: {
                    this.performDownAction();
                    break;
                }
                case 0x10000000: {
                    this.performDeleteAction();
                }
            }
        }
    }

    public String getCurrentExpressionItem() throws VWException {
        String expressionString = null;
        this.m_arrayEditorTable.stopEditing();
        String[] stringArray = this.m_arrayEditorTableModel.getStringArray();
        if (stringArray != null) {
            String[] tempArray;
            expressionString = "{";
            int count = stringArray.length;
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    if (stringArray[i] == null || VWStringUtils.compare(stringArray[i], "") == 0) {
                        stringArray[i] = this.getDefaultValue();
                    }
                    expressionString = expressionString + stringArray[i];
                    if (i == count - 1) continue;
                    expressionString = expressionString + ",";
                }
            }
            if ((tempArray = VWExpression.stringToArray(expressionString = expressionString + "}")) == null) {
                throw new VWException("vw.toolkit.utils.uicontrols.expressionbuilder.EmptyExpressionArrayString", "The array does not contain any valid values.");
            }
            if (tempArray.length != stringArray.length) {
                throw new VWException("vw.toolkit.utils.uicontrols.expressionbuilder.ErrorParsingExpressionArrayString", "Element {0} in the array is an invalid value. Please check the syntax.", Integer.toString(tempArray.length + 1));
            }
        }
        return expressionString;
    }

    public void setEnableControls(boolean enable) {
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_arrayEditorTable.getSelectedRow();
            if (this.m_arrayEditorTableModel != null && nRowIndex != -1) {
                int nRowCount;
                this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                if (nRowIndex == 0) {
                    this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 2, 1));
                }
                if (nRowIndex == (nRowCount = this.m_arrayEditorTableModel.getRowCount()) - 1) {
                    this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 2, 2));
                }
                if (nRowCount == 1) {
                    this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 2, 0x10000000));
                }
            }
        }
    }

    private void initControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_arrayEditorBorder = new VWToolbarBorder(this.m_name, 0x10000013);
        this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_arrayEditorBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_arrayEditorBorder.getClientPanel(), 1, 16));
        this.m_arrayEditorBorder.addToolbarBorderActionNotifier(this);
        this.add((Component)this.m_arrayEditorBorder, this.m_gbCons);
        JPanel arrayEditorPanel = this.m_arrayEditorBorder.getClientPanel();
        arrayEditorPanel.setLayout(new GridLayout());
        this.m_arrayEditorTableModel = new VWArrayEditorTableModel();
        this.m_arrayEditorTable = new VWArrayEditorTable(this.m_arrayEditorTableModel);
        this.m_arrayEditorTable.setRowSelectionAllowed(true);
        this.m_arrayEditorTable.getSelectionModel().addListSelectionListener(this);
        this.m_arrayEditorTable.getSelectionModel().setSelectionMode(0);
        arrayEditorPanel.add(new JScrollPane(this.m_arrayEditorTable));
        TableColumn tcElement = this.m_arrayEditorTable.getColumnModel().getColumn(1);
        if (tcElement != null) {
            tcElement.setCellEditor(new VWExpressionCellEditorForFieldTable(this.m_propertyData, this.m_type == 4));
        }
    }

    private void performGetArrayButtonAction() {
        if (this.m_expressionEditor != null) {
            String selectedText = this.m_expressionEditor.getSelectedText();
            String[] array = VWExpression.stringToArray(selectedText);
            this.m_arrayEditorTableModel.init(array);
            this.m_arrayEditorTableModel.reinitialize();
        }
    }

    private void performAddAction(String defaultValue) {
        this.m_arrayEditorTableModel.addItem(defaultValue);
        int lastRowIndex = this.m_arrayEditorTableModel.getRowCount() - 1;
        this.m_arrayEditorTable.setRowSelectionInterval(lastRowIndex, lastRowIndex);
    }

    private void performDeleteAction() {
        int row = this.m_arrayEditorTable.getSelectedRow();
        this.m_arrayEditorTableModel.deleteItem(row);
        int nextRowIndex = row - 1;
        if (nextRowIndex < 0) {
            nextRowIndex = 0;
        }
        if (this.m_arrayEditorTableModel.getRowCount() > 0) {
            this.m_arrayEditorTable.setRowSelectionInterval(nextRowIndex, nextRowIndex);
        }
    }

    private void performUpAction() {
        int row = this.m_arrayEditorTable.getSelectedRow();
        this.m_arrayEditorTableModel.up(row);
        this.m_arrayEditorTable.setRowSelectionInterval(row - 1, row - 1);
    }

    private void performDownAction() {
        int row = this.m_arrayEditorTable.getSelectedRow();
        this.m_arrayEditorTableModel.down(row);
        this.m_arrayEditorTable.setRowSelectionInterval(row + 1, row + 1);
    }

    public void stopEditing() {
        this.m_arrayEditorTable.stopEditing();
    }

    private String getDefaultValue() {
        String defaultValue = "";
        switch (this.m_type) {
            case 4: {
                defaultValue = "true";
                break;
            }
            case 8: {
                defaultValue = "0.0";
                break;
            }
            case 1: {
                defaultValue = "0";
                break;
            }
            case 2: {
                defaultValue = "\"\"";
                break;
            }
            case 16: {
                defaultValue = "systemtime()";
            }
        }
        return defaultValue;
    }
}

